<?php
require_once __DIR__ . '/../app/security.php';
require_once __DIR__ . '/../app/helpers.php';
require_once __DIR__ . '/../app/middleware/csrf.php';
require_once __DIR__ . '/../app/models/User.php';
require_once __DIR__ . '/../app/auth.php';

start_secure_session();

// Simple rate limit: max 10 attempts per 10 minutes (per session)
if (!isset($_SESSION['login_attempts'])) $_SESSION['login_attempts'] = [];
$_SESSION['login_attempts'] = array_filter($_SESSION['login_attempts'], fn($t) => $t > time() - 600);
if (count($_SESSION['login_attempts']) > 10) {
    http_response_code(429);
    die("Too many login attempts. Try again later.");
}

$errors = [];
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    verify_csrf();
    $_SESSION['login_attempts'][] = time();

    $email = trim((string)post('email'));
    $password = (string)post('password');

    if (!filter_var($email, FILTER_VALIDATE_EMAIL)) $errors[] = "Valid email is required.";
    if ($password === '') $errors[] = "Password is required.";

    if (!$errors) {
        $user = User::findByEmail($email);
        if ($user && password_verify($password, $user['password'])) {
            login_user((int)$user['id']);
            redirect('/dashboard.php');
        } else {
            $errors[] = "Invalid credentials.";
        }
    }
}

require __DIR__ . '/../app/views/head.php';
require __DIR__ . '/../app/views/navbar.php';
?>
<div class="container">
  <div class="row justify-content-center">
    <div class="col-md-6">
      <div class="card shadow-sm">
        <div class="card-body">
          <h3 class="mb-3">Login</h3>

          <?php if($errors): ?>
            <div class="alert alert-danger">
              <ul class="mb-0">
                <?php foreach($errors as $e): ?><li><?= e($e) ?></li><?php endforeach; ?>
              </ul>
            </div>
          <?php endif; ?>

          <form method="post">
            <?= csrf_field() ?>
            <div class="mb-3">
              <label class="form-label">Email</label>
              <input type="email" class="form-control" name="email" value="<?= e((string)post('email')) ?>" required>
            </div>
            <div class="mb-3">
              <label class="form-label">Password</label>
              <input type="password" class="form-control" name="password" required>
            </div>
            <button class="btn btn-primary w-100">Login</button>
          </form>

          <div class="mt-3 text-center">
            New here? <a href="/register.php">Create account</a>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>
<?php require __DIR__ . '/../app/views/foot.php'; ?>
