<?php
require_once __DIR__ . '/config.php';

function start_secure_session(): void {
    if (session_status() === PHP_SESSION_ACTIVE) return;

    $params = session_get_cookie_params();
    session_set_cookie_params([
        'lifetime' => 0,
        'path' => $params['path'] ?? '/',
        'domain' => $params['domain'] ?? '',
        'secure' => SESSION_SECURE,
        'httponly' => true,
        'samesite' => SESSION_SAMESITE ?: 'Lax',
    ]);

    ini_set('session.use_strict_mode', '1');
    ini_set('session.cookie_httponly', '1');
    if (SESSION_SECURE) ini_set('session.cookie_secure', '1');
    session_name('moneymate_session');
    session_start();

    if (empty($_SESSION['_regen'])) {
        session_regenerate_id(true);
        $_SESSION['_regen'] = time();
    }
}

function e(string $s): string {
    return htmlspecialchars($s, ENT_QUOTES | ENT_SUBSTITUTE, 'UTF-8');
}
