<?php
require_once __DIR__ . '/../security.php';

function csrf_token(): string {
    start_secure_session();
    if (empty($_SESSION['csrf'])) {
        $_SESSION['csrf'] = bin2hex(random_bytes(32));
    }
    return $_SESSION['csrf'];
}

function csrf_field(): string {
    $t = csrf_token();
    return '<input type="hidden" name="csrf" value="' . e($t) . '">';
}

function verify_csrf(): void {
    start_secure_session();
    $sent = $_POST['csrf'] ?? '';
    if (!$sent || !hash_equals($_SESSION['csrf'] ?? '', $sent)) {
        http_response_code(403);
        die("Invalid CSRF token.");
    }
}
