<?php
function post(string $key, $default='') {
    return $_POST[$key] ?? $default;
}
function get(string $key, $default='') {
    return $_GET[$key] ?? $default;
}

function is_valid_type(string $type): bool {
    return in_array($type, ['income','expense'], true);
}

function validate_amount($amount): bool {
    return is_numeric($amount) && (float)$amount >= 0;
}

function redirect(string $path): void {
    header("Location: $path");
    exit;
}
